<?php
/**
 * Thrive Themes - https://thrivethemes.com
 *
 * @package thrive-apprentice
 */

namespace TVA\Stripe;

use function add_action;
use function add_filter;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Silence is golden!
}

class Hooks {

	public static function init() {
		static::add_actions();
		static::add_filters();
	}

	public static function add_actions() {
		add_action( 'current_screen', [ __CLASS__, 'check_account_redirect' ] );
	}

	public static function add_filters() {
		add_filter( 'tva_admin_localize', [ __CLASS__, 'admin_localize' ] );
	}

	public static function admin_localize( $data = [] ) {
		$connection = Connection::get_instance();

		$data['stripe'] = [
			'api_key'      => $connection->get_api_key(),
			'test_api_key' => $connection->get_test_key(),
			'account_id'   => $connection->get_account_id(),
		];

		return $data;
	}

	public static function check_account_redirect() {
		$current_screen = tve_get_current_screen_key();

		if ( $current_screen
			 && $current_screen === 'thrive-dashboard_page_thrive_apprentice'
			 && isset( $_GET['tve_stripe_connect'], $_GET['stripe_user_id'] )
			 && (bool) $_GET['tve_stripe_connect'] === true ) {
			$stripe_user_id = sanitize_text_field( $_GET['stripe_user_id'] );

			$stripe_client = Connection::get_instance();

			$current_account_id = $stripe_client->get_account_id();

			if ( ! $current_account_id ) {
				$stripe_client->save_account_id( $stripe_user_id );
			}
		}
	}
}
