<?php
/**
 * Thrive Themes - https://thrivethemes.com
 *
 * @package thrive-apprentice
 */

namespace TVA\Buy_Now;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Silence is golden!
}

abstract class Generic {

	protected $data;

	public function __construct( $data ) {
		$this->data = $data;
	}

	public static function get_integrations() {
		return [
			'stripe'         => __( 'Stripe', 'thrive-apprentice' ),
			'custom_payment' => __( 'Custom payment', 'thrive-apprentice' ),
		];
	}

	public function is_valid() {
		return true;
	}

	/**
	 * @return string
	 */
	abstract public function get_url();

	public static function get_class_name( $identifier ) {
		$identifier = str_replace( '_', ' ', $identifier );
		$identifier = ucwords( $identifier );

		return str_replace( ' ', '_', $identifier );
	}

	public static function get_instance( $data = [] ) {
		$instance = null;
		if ( ! empty( $data['integration'] ) ) {
			$class_name = __NAMESPACE__ . '\\' . static::get_class_name( $data['integration'] );

			if ( class_exists( $class_name ) ) {
				unset( $data['integration'] );
				$instance = new $class_name( $data );
			}
		}

		return $instance;
	}
}
